<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once dirname(__DIR__) . '/../includes/functions.php';

// Check if user is admin
if (!is_admin()) {
    header('Location: ../login.php');
    exit();
}

ob_start();

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Car Dealership</title>
    
    <!-- Lux Bootstrap Theme -->
    <link href="https://bootswatch.com/5/lux/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom Admin Styles -->
    <style>
        :root {
            --sidebar-width: 250px;
            --navbar-height: 60px;
            --primary-color: #333;
            --transition-speed: 0.3s;
        }

        /* Scrollbar Styles */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
        
        /* Table Container Styles */
        .card-body {
            transition: all 0.3s ease;
        }
        
        .table-responsive {
            margin-bottom: 0;
        }
        
        .table thead th {
            position: sticky;
            top: 0;
            background: white;
            z-index: 1;
            border-top: none;
        }

        body {
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .admin-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: var(--primary-color);
            transition: all var(--transition-speed);
            z-index: 1000;
            padding-top: var(--navbar-height);
        }

        .admin-sidebar.collapsed {
            left: calc(-1 * var(--sidebar-width));
        }

        .admin-sidebar .nav-link {
            color: #fff;
            padding: 12px 20px;
            transition: all var(--transition-speed);
            border-left: 3px solid transparent;
        }

        .admin-sidebar .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
            border-left-color: #fff;
        }

        .admin-sidebar .nav-link.active {
            background: rgba(255, 255, 255, 0.1);
            border-left-color: #fff;
        }

        .admin-sidebar .nav-link i {
            width: 25px;
            text-align: center;
            margin-right: 10px;
        }

        /* Navbar Styles */
        .admin-navbar {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: var(--navbar-height);
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            z-index: 1001;
            transition: all var(--transition-speed);
        }

        .admin-navbar.sidebar-open {
            left: var(--sidebar-width);
        }

        /* Main Content */
        .admin-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--navbar-height);
            padding: 20px;
            transition: all var(--transition-speed);
        }

        .admin-content.sidebar-collapsed {
            margin-left: 0;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .admin-sidebar {
                left: calc(-1 * var(--sidebar-width));
            }

            .admin-sidebar.mobile-open {
                left: 0;
            }

            .admin-navbar {
                left: 0;
            }

            .admin-content {
                margin-left: 0;
            }
        }

        /* Animation Classes */
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        .slide-in {
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from { transform: translateX(-20px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="admin-navbar">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center h-100">
                <div class="d-flex align-items-center">
                    <button id="sidebarToggle" class="btn">
                        <i class="fas fa-bars"></i>
                    </button>
                    <span class="ms-3 fw-bold">Car Dealership Admin</span>
                </div>
                <div class="d-flex align-items-center">
                    <div class="dropdown">
                        <button class="btn dropdown-toggle" type="button" id="userDropdown" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle"></i>
                            <?php echo $_SESSION['username'] ?? 'Admin'; ?>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="../index.php">View Website</a></li>
                            <li><a class="dropdown-item" href="profile.php">Profile</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="../logout.php">Logout</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- Sidebar -->
    <div class="admin-sidebar">
        <div class="nav flex-column">
            <a href="index.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a href="manage_cars.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_cars.php' ? 'active' : ''; ?>">
                <i class="fas fa-car"></i> Manage Cars
            </a>
            <a href="manage_brands.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_brands.php' ? 'active' : ''; ?>">
                <i class="fas fa-trademark"></i> Manage Brands
            </a>
            <a href="manage_models.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_models.php' ? 'active' : ''; ?>">
                <i class="fas fa-car-side"></i> Manage Models
            </a>
            <a href="manage_users.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_users.php' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i> Manage Users
            </a>
            <a href="inquiries.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'inquiries.php' ? 'active' : ''; ?>">
                <i class="fas fa-envelope"></i> Inquiries
            </a>
            <a href="settings.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i> Settings
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <div class="admin-content"> 